<?php 
if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}?>
<?php
require get_template_directory() . '/inc/wp_bootstrap_navwalker.php'; // activation sous menu


/* 
*  Setup standard WP
**************************************/
if ( ! function_exists( 'wpweddu_setup' ) ) :
function wpweddu_setup() {
	
	// ajout dans la personnalisation du theme via l'administration
	add_theme_support( 'title-tag' );
	add_theme_support( 'post-thumbnails' );
    add_theme_support( 'custom-logo' );
	
	// emplacement menus (ne pas oublier de créer les menus dans l'admin et de les associer à un emplacement)
    register_nav_menus( array(
        'main'    => __( 'Menu de navigation', 'wpweddu' )
    ) );


}
endif; 
add_action( 'after_setup_theme', 'wpweddu_setup' );


/**
 * Delete MENU COMMENT.
**************************************/
function remove_menus() {
	//remove_menu_page( 'index.php' );                  //Dashboard
	//remove_menu_page( 'jetpack' );                    //Jetpack* 
	//remove_menu_page( 'edit.php' );                   //Posts
	//remove_menu_page( 'upload.php' );                 //Media
	//remove_menu_page( 'edit.php?post_type=page' );    //Pages
	remove_menu_page( 'edit-comments.php' );          //Comments
	//remove_menu_page( 'themes.php' );                 //Appearance
	//remove_menu_page( 'plugins.php' );                //Plugins
	//remove_menu_page( 'users.php' );                  //Users
	//remove_menu_page( 'tools.php' );                  //Tools
	//remove_menu_page( 'options-general.php' );        //Settings
}
add_action( 'admin_menu', 'remove_menus' );


/**
 * Enqueue scripts and styles.
**************************************/
function wpweddu_scripts() {
    
    // Theme fonts.
    wp_enqueue_style( 'wpb-google-fonts', 'https://fonts.googleapis.com/css?family=Montserrat&display=swap', false );

	// Theme stylesheet.
	wp_enqueue_style( 'style', get_stylesheet_uri(), array(), date('His'));
    wp_enqueue_style( 'bootstrap', 'https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0-beta/css/bootstrap.min.css', array(), '4.0.0');
    wp_enqueue_style( 'font-awsome', 'https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css', array(), '4.7.0');
    
    // Theme javascript
    wp_enqueue_script( 'jquery', 'https://code.jquery.com/jquery-3.2.1.slim.min.js', array(), '',true );
    wp_enqueue_script( 'popper', 'https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.11.0/umd/popper.min.js', array(), '',true );
    wp_enqueue_script( 'bootstrap', 'https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0-beta/js/bootstrap.min.js', array(), '',true );
    wp_enqueue_script( 'application', get_theme_file_uri( '/assets/js/app.js' ), array(), date('His'),true );
    //wp_enqueue_script( 'jquery', get_theme_file_uri( '/assets/js/jquery.min.js' ), array(), '',true );
    //wp_enqueue_script( 'bootstrap', get_theme_file_uri( '/assets/js/bootstrap.min.js' ), array(), '3.3.7',true );
    
    // Stylesheet and Script standard web
	// Load the Internet Explorer 9 specific stylesheet, to fix display issues in the Customizer.
	if ( is_customize_preview() ) {
		wp_enqueue_style( 'wpweddu-ie9', get_theme_file_uri( '/assets/css/ie9.css' ), array( 'wpweddu-style' ), '1.0' );
		wp_style_add_data( 'wpweddu-ie9', 'conditional', 'IE 9' );
	}

	// Load the Internet Explorer 8 specific stylesheet.
	wp_enqueue_style( 'wpweddu-ie8', get_theme_file_uri( '/assets/css/ie8.css' ), array( 'wpweddu-style' ), '1.0' );
	wp_style_add_data( 'wpweddu-ie8', 'conditional', 'lt IE 9' );

	// Load the html5 shiv.
	wp_enqueue_script( 'html5', get_theme_file_uri( '/assets/js/html5.js' ), array(), '3.7.3' );
	wp_script_add_data( 'html5', 'conditional', 'lt IE 9' );

}
add_action( 'wp_enqueue_scripts', 'wpweddu_scripts' );



/**
 * Register sidebar / widget
**************************************/
function wpweddu_widgets_init() {

    // Sidebar Right
    register_sidebar( array(
        'name' => __( 'Sidebar droite', 'wpweddu' ),
        'id' => 'sidebar-right',
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h4 class="widget-title">',
        'after_title'   => '</h4>',
    ) ); 
 
    // Footer colonne de gauche
    register_sidebar( array(
        'name' => __( 'Footer colonne 1', 'wpweddu' ),
        'id' => 'footer-col-1',
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h4 class="widget-title">',
        'after_title'   => '</h4>',
    ) );
    
    // Footer colonne du milieu 
    register_sidebar( array(
        'name' => __( 'Footer colonne 2', 'wpweddu' ),
        'id' => 'footer-col-2',
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h4 class="widget-title">',
        'after_title'   => '</h4>',
    ) );
    
    // Footer colonne de droite
    register_sidebar( array(
        'name' => __( 'Footer colonne 3', 'wpweddu' ),
        'id' => 'footer-col-3',
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h4 class="widget-title">',
        'after_title'   => '</h4>',
    ) );
    

}
add_action( 'widgets_init', 'wpweddu_widgets_init' );


/**
*  Customize footer
**************************************/
function wpweddu_set_footer(){
    
    $col = 0;
    $pos = array();
    
    for($i=1; $i <= 4; $i++){ 
        if(is_active_sidebar('footer-col-'.$i)){
            $col++;
            $pos[] = $i;
        }
    }
    
    return $pos;
}

function wpweddu_get_col_footer($v){
    return $t = count($v); 
}


/**
*  Show link edit when user connected
**************************************/
function wpweddu_edit_post() {

	$link = edit_post_link(
		sprintf(
			/* translators: %s: Name of current post */
			__( 'Modifier', 'wpweddu' ),
			get_the_title()
		),
		'| <span class="edit-link">',
		'</span>'
	); 
	return $link;
}

/**
*  Show Menu Description
**************************************/
function prefix_nav_description( $item_output, $item, $depth, $args ) {
    if ( !empty( $item->description ) ) {
        $item_output = str_replace( $args->link_after . '</a>', '<span class="menu-item-description">' . $item->description . '</span>' . $args->link_after . '</a>', $item_output );
    }
    return $item_output;
}
add_filter( 'walker_nav_menu_start_el', 'prefix_nav_description', 10, 4 );

?>