<?php 
if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}?>
<!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js no-svg">
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<meta name="author" content="SNC Pamatai">
<meta name="description" content="Votre domaine résidentiel de haut standing à Tahiti">
<!-- Open Graph -->
<meta property="og:title" content="Pamatai Hills | Votre domaine résidentiel de haut standing à Tahiti" />
<meta property="og:type" content="web" />
<meta property="og:url" content="http://www.pamataihills.pf/" />
<meta property="og:image" content="http://192.168.240.112/client/pamatai-hills-new/wp-content/uploads/2019/06/template.jpg" />

<link rel="profile" href="http://gmpg.org/xfn/11">

<?php wp_head(); ?>

<!-- Global site tag (gtag.js) - Google Analytics -->
<!--<script async src="https://www.googletagmanager.com/gtag/js?id=UA-27271709-3"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'UA-27271709-3');
</script>-->

<!-- Facebook Pixel Code -->
<!--<script>
!function(f,b,e,v,n,t,s)
{if(f.fbq)return;n=f.fbq=function(){n.callMethod?
n.callMethod.apply(n,arguments):n.queue.push(arguments)};
if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
n.queue=[];t=b.createElement(e);t.async=!0;
t.src=v;s=b.getElementsByTagName(e)[0];
s.parentNode.insertBefore(t,s)}(window,document,'script',
'https://connect.facebook.net/en_US/fbevents.js');
fbq('init', '386544595100205'); 
fbq('track', 'PageView');
</script>
<noscript>
<img height="1" width="1" 
src="https://www.facebook.com/tr?id=386544595100205&ev=PageView
&noscript=1"/>
</noscript>-->
<!-- End Facebook Pixel Code -->
</head>

<body <?php body_class('wed'); ?>>
    <nav class="navbar navbar-expand-md navbar-dark bg-header py-3">
        <div class="container">
            <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarsExampleDefault" aria-controls="navbarsExampleDefault" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarsExampleDefault">
                <?php wp_nav_menu( array(
                    'theme_location'    => 'main',
                    'container'         => 'ul',
                    'container_class'   => 'navbar-nav mr-auto',
                    'menu_class'        => 'navbar-nav mr-auto menu_class',
                    'container_id'      => '',
                    'fallback_cb'       => 'wp_bootstrap_navwalker::fallback',
                    'walker'            => new wp_bootstrap_navwalker()
                )); ?>
            </div>
        </div>
    </nav>
    <div class="logo">
        <a href="<?= home_url()?>" hidefocus="true" style="outline: none;"><img src="<?php echo get_template_directory_uri();?>/assets/files/logo-pamatai-hills.png" border="0"></a>
    </div>

