<?php 
if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}?>
<?php get_header();?>
<div class="container">
    <div class="row">
        <div class="col-sm-8">
            
            <?php
                if ( have_posts() ) :
                    while ( have_posts() ) : the_post();
            ?>
                    <div id="post-<?php the_ID(); ?>" <?php post_class('sect'); ?>>
                        <h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
                        <?php echo get_the_post_thumbnail(null, array(),array('class'=>'img-responsive'));?>
                        <p class="date_publish">Publié par <?php the_author();?> le <?php the_date();?> <?php wpweddu_edit_post( get_the_ID() ); ?></p> 
                        <p><?php the_excerpt(); ?></p>
                        <a class="btn btn-primary" href="<?php the_permalink(); ?>">Lire la suite<span class="glyphicon glyphicon-chevron-right"></span></a>
                    </div>
            <?php
                    endwhile;
                else :
                        get_template_part( 'template-parts/content', 'none' );

                endif;
            ?>
        </div>
        <div class="col-sm-4 aside"><?php dynamic_sidebar('sidebar-archive');?></div>
    </div>
</div>
<?php get_footer();?>