<?php
// source : https://openclassrooms.com/courses/propulsez-votre-site-avec-wordpress/creer-des-widgets
// ou
// cf livre Wordpress "Développez avec PHP" page 387

/****
* List custom post type
-------------------------------------*/
class Widget_Post extends WP_Widget{
    
    // Configuration du widget
    function Widget_Post(){
        
        $widget_ops = array(
            'classname'   => 'widget-post',
            'description' => 'Liste d\'articles selon la catégorie',
        );
        
        $control_ops = array(
            'height'   => 350,
            'id_base'  => 'widget-post',
        );
        
        // WP_Widget(slug, name, $widget_ops, $control_ops);
        $this->WP_Widget('widget-post', 'Widget post', $widget_ops, $control_ops);
        
    }
    
    // Formulaire back end
    function form($instance){
        
        $defaults = array('title'=>'Articles');
        $instance = wp_parse_args($instance, $defaults);

    ?>
        <p>
            <label for="<?php echo $this->get_field_id('title');?>">Titre:</label>
            <input type="text" id="<?php echo $this->get_field_id('title');?>" name="<?php echo $this->get_field_name('title');?>" value="<?php echo $instance['title'];?>" style="width:100%">
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('category');?>">Catégorie:</label>
            <select id="<?php echo $this->get_field_id('category');?>" name="<?php echo $this->get_field_name('category');?>" value="<?php echo $instance['category'];?>" style="width:100%">
                <option>Toutes les catégories</option>
                <?php 
                    foreach(get_categories() as $cat){
                        if($instance['category']==$cat->cat_ID){
                            $selected='selected="selected"';
                        }else{
                            $selected='';
                        }
                        echo '<option '.$selected.' value="'.$cat->cat_ID.'">'.$cat->cat_name.'</option>';
                    }
                ?>
            </select>
        </p>
    <?php
    }
    
    // Mise à jour des options 
    function update($new_instance, $old_instance){
        
        $instance = $old_instance;
        
        $instance['title'] = strip_tags($new_instance['title']);
        $instance['category'] = strip_tags($new_instance['category']);
        
        return $instance;
        
    }
    
    // Rendre la vue - front end
    function widget($args, $instance){
        //echo 'yess baby !!!';   
        extract($args);
        global $post;
        
        echo $before_widget;
        
        if($instance['title'] != ''){
            echo $before_title.$instance['title'].$after_title;
        }
     
        if($instance['category'] != ''){
            $args = array('category' => $instance['category']);
        }else{
            $args = '';
        }
        
        $myposts = get_posts($args);
        
        echo'<ul>';
            foreach($myposts as $post){
                setup_postdata($post);
                echo '<li>';
                echo '<a href="'.get_the_permalink().'">'.get_the_title().'</a>';
                echo '</li>';
            }
        echo '</lu>';
        wp_reset_postdata();
     
        echo $after_widget;
            
    }
    
    
}